// Update years
const yearEls = [document.getElementById('year'), document.getElementById('year2'), document.getElementById('year3'), document.getElementById('year4')];
const y = new Date().getFullYear();
yearEls.forEach(e=>{ if(e) e.textContent = y });

// Mobile nav toggle
const btn = document.querySelectorAll('.nav-toggle');
btn.forEach(b => b.addEventListener('click', ()=>{
  document.querySelector('.main-nav').classList.toggle('open');
}));

// Product list
if(document.getElementById('productGrid')){
  const products = [
    {id:1,title:'Oak Accent Chair',price:45000,img:'images/chair-1.jpg'},
    {id:2,title:'Two-seater Sofa',price:120000,img:'images/sofa-1.jpg'},
    {id:3,title:'Minimalist Coffee Table',price:32000,img:'images/table-1.jpg'},
    {id:4,title:'Classic Bookshelf',price:60000,img:'images/shelf-1.jpg'}
  ];
  const grid = document.getElementById('productGrid');
  products.forEach(p=>{
    const a = document.createElement('article'); a.className='card';
    a.innerHTML = `<img src=\"${p.img}\" alt=\"${p.title}\"><h3>${p.title}</h3><p class='price'>₦${p.price.toLocaleString()}</p><p><a href='contact.html' class='btn-small'>Enquire</a></p>`;
    grid.appendChild(a);
  });
}

// Contact form demo
const contactForm = document.getElementById('contactForm');
if(contactForm){
  contactForm.addEventListener('submit', e=>{
    e.preventDefault();
    alert('Thank you — message received (demo)');
    contactForm.reset();
  })
}